//Constellation diagram of BPSK and QPSK modulation and BPSK and QPSK modulation over AWGN channel
clc;
clear;
xdel(winsid());
sym=20;//No .of symbols
data1=grand(1,sym,"uin",0,1);//Random symbol generation from 0 to 1 with uniform distribution  
snr=10;// Signal to Noise Ratio
qpsk_mod=[];
bpsk_mod=2*data1-1;//BPSK Modulation
for j=1:2:length(data1)// Seperation of I & Q component for QPSK modulation
   i_phase=2*data1(j)-1;//BPSK modulation of I phase component
   q_phase=2*data1(j+1)-1;//BPSK modulation of Q phase component
   temp=i_phase+%i*q_phase;//Combinibg I phase and Q phase component for QPSK modulation
   qpsk_mod=[qpsk_mod temp];//QPSK modulated signal
 end

  noise=1/sqrt(2)*(10^(-(snr/20)))*(rand(1,length(bpsk_mod),'normal')+%i*(rand(1,length(bpsk_mod),'normal')));//White gaussian noise generation for bpsk
  noise1=1/sqrt(2)*(10^(-(snr/20)))*(rand(1,length(qpsk_mod),'normal')+%i*(rand(1,length(qpsk_mod),'normal')));//White gaussian noise generation for qpsk
  bpsk_awgn=bpsk_mod+noise;//BPSK Modulated signal passed over AWGN channel
 qpsk_awgn=qpsk_mod+noise1;//QPSK Modulated signal passed over AWGN channel
 
 figure//constellation diagram of ideal BPSK modulated signal and BPSK modulated signal with White Gaussian Noise
a = gca();//to handle various object
a.data_bounds = [ -1 , -1;1 ,1];
a.x_location = "origin";
a.y_location = "origin";
plot2d ( real(bpsk_mod),imag(bpsk_mod),-2);
plot2d ( real(bpsk_awgn),imag(bpsk_awgn),-5);
xlabel( 'In phase' );//X-axis label
ylabel( 'Quadrature phase' );//Y-axis label
title( 'Constellation for BPSK with AWGN' );//title of plot
legend(['Ideal message point';'message point with noise']);//legend
mtlb_axis([-2 2 -2 2]);//range of axis
figure//constellation diagram of ideal QPSK modulated signal and QPSK modulated signal with White Gaussian Noise
a = gca();//to handle various object
a.data_bounds = [ -1 , -1;1 ,1];
a.x_location = "origin";
a.y_location = "origin";
plot2d ( real(qpsk_mod),imag(qpsk_mod),-2);
plot2d ( real(qpsk_awgn),imag(qpsk_awgn),-5);
xlabel( 'In phase' );//X-axis label
ylabel( 'Quadrature phase' );//Y-axis label
title( 'Constellation for QPSK with AWGN' );//title of plot
legend(['Ideal message point';'message point with noise']);//legend
mtlb_axis([-2 2 -2 2]);//range of axis
//Result:Generates two plots: BPSK modulated signal with and without noise-figure-0
                     //QPSK modulated signal with and without noise-figure-1
                     
